<?php
header('Content-Type: application/json');

// URL da API
$api_url = 'https://my.nocix.net/api/in-stock-servers/';

// Autenticação
$user = '49912_nottorium';
$auth_token = 'fm5qgx4yd09mxpgrye8zit6uoxe45y89';
$auth_base64 = base64_encode("$user:$auth_token");

// Inicialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Basic ' . $auth_base64));

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['error' => 'Erro de cURL: ' . curl_error($ch)]);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if ($http_code !== 200) {
    echo json_encode(['error' => 'Código de status HTTP: ' . $http_code]);
    exit;
}

// Tente decodificar o JSON
$data = json_decode($response, true);
if ($data === null) {
    echo json_encode(['error' => 'Erro ao decodificar JSON: ' . json_last_error_msg()]);
    exit;
}

// Adicione log da estrutura de dados recebida
echo json_encode($data, JSON_PRETTY_PRINT);

if (!is_array($data) || count($data) === 0) {
    echo json_encode(['error' => 'Formato de dados inesperado ou vazio']);
    exit;
}

// Filtragem e formatação dos dados
$products = [];

foreach ($data as $serverId => $server) {
    // Adicione log para entender a estrutura de cada servidor
    if (is_array($server)) {
        // Verifique se as chaves necessárias existem
        if (isset($server['id'], $server['name'], $server['price'], $server['qty'], $server['deployment_type'])) {
            $products[] = [
                'id' => $server['id'],
                'name' => $server['name'],
                'details' => [
                    'price' => $server['price'],
                    'qty' => $server['qty'],
                    'deployment_type' => $server['deployment_type'],
                    'os_list' => $server['metadata']['os_list'] ?? [],
                    'initial_os_list' => $server['metadata']['initial_os_list'] ?? [],
                    'processor' => $server['metadata']['ordering']['processor'] ?? null,
                    'ram' => $server['metadata']['ordering']['ram'] ?? null,
                    'storage' => $server['metadata']['ordering']['storage'] ?? null,
                    'included' => $server['metadata']['ordering']['included'] ?? null,
                ]
            ];
        } else {
            echo json_encode(['error' => "Dados de servidor em formato inesperado: " . json_encode($server)]);
            exit;
        }
    } else {
        echo json_encode(['error' => "Servidor não é um array: " . json_encode($server)]);
        exit;
    }
}

// Estrutura da saída JSON para itens separados
$output = ['products' => $products];

// Enviar dados filtrados de volta como JSON
echo json_encode($output, JSON_PRETTY_PRINT);
curl_close($ch);
?>